VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4620
   ClientLeft      =   2865
   ClientTop       =   1725
   ClientWidth     =   6120
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   4620
   ScaleWidth      =   6120
   Begin VB.CommandButton cmdStop 
      Caption         =   "Disable IRQ Processing"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   10
      Top             =   2400
      Width           =   2295
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   4320
      TabIndex        =   9
      Top             =   3720
      Width           =   855
   End
   Begin VB.Frame Frame1 
      Caption         =   "Edge Select"
      Height          =   975
      Left            =   3120
      TabIndex        =   6
      Top             =   1560
      Width           =   2055
      Begin VB.OptionButton optExternal 
         Caption         =   "Falling Edge"
         Height          =   195
         Left            =   360
         TabIndex        =   8
         Top             =   600
         Width           =   1335
      End
      Begin VB.OptionButton optRisingEdge 
         Caption         =   "Rising Edge"
         Height          =   255
         Left            =   360
         TabIndex        =   7
         Top             =   240
         Value           =   -1  'True
         Width           =   1575
      End
   End
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   3120
      TabIndex        =   4
      TabStop         =   0   'False
      Text            =   "0"
      Top             =   960
      Width           =   735
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   600
      TabIndex        =   3
      Top             =   960
      Width           =   2295
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   3600
      Top             =   120
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Enable IRQ Processing"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   1
      Top             =   1680
      Width           =   2295
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   2640
      Top             =   120
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label2 
      Caption         =   "DriverLINX Device Number: "
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   3000
      TabIndex        =   5
      Top             =   720
      Width           =   2055
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   360
      Left            =   360
      TabIndex        =   2
      Top             =   240
      Width           =   1845
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      Height          =   255
      Left            =   480
      TabIndex        =   0
      Top             =   3120
      Width           =   4335
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'
'  tested in Win98SE with KPCMCIA-PIO24-C
'  using KPCMCIA-850A04 version of the DriverLINX driver
'
' this example programs an IRQ mode DI task that makes use of the
' external IRQ pin for pacing.  When the edge occurs one sample is taken
' and a buffer filled message is sent.
' We don't care about the sample....it is the message that let's us know
' the edge at the IRQ line (pin 1) has occurred.

Private Sub cmdExit_Click()
' stop any task that might be active
With SR
.Req_op = DL_STATUS
.Refresh
End With
' if the status operation can succeed, the task must be active
' and therefore needs stopped before exit
If SR.Res_result = DL_NoErr Then
SR.Req_op = DL_STOP
SR.Refresh
End If
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
' exit
End
End Sub

Private Sub cmdInit_Click()
' open driver and initialize hardware
With SR
.Req_DLL_name = "kpcpio$"  ' driver name for KPCMCIA-PIO24-C cards
' init the hardware
.Req_device = devNum.ListIndex  ' device number assigned in DLinx Config Panel
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With
If SR.Res_result <> DL_NoErr Then
' respond to error
lblStatus.Caption = SR.Message
Else
' no error occured
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.device = SR.Req_device
LDD.Refresh
Form1.Caption = "IRQ at Pin 1 Detection with " & LDD.Dev_Model
cmdInit.Enabled = False
cmdStart.Enabled = True
lblStatus.Caption = "Board Ready"
End If
Form1.SetFocus
End Sub

Private Sub cmdStart_Click()
Frame1.Enabled = False ' disallow clock select
lblStatus.Caption = "Starting task......"
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_INTERRUPT  ' could be DL_DMA if board has DMA feature
.Req_subsystem = DL_DI
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_COMMAND  ' stop when told to do so
.Evt_Tim_type = DL_RATEEVENT ' timing will be used
.Evt_Tim_rateChannel = DL_DEFAULTTIMER
If optRisingEdge.Value = True Then
.Evt_Tim_rateClock = DL_EXTERNALPE  'will use the default rising edge of external signal
Else
.Evt_Tim_rateClock = DL_EXTERNALNE  ' will use falling edge
End If
.Evt_Tim_rateGate = DL_NOCONNECT   ' no gating
.Evt_Tim_rateMode = DL_RATEGEN     ' one sample for each tic of clock
' ratePeriod is not really used, but the driver wants an estimate of the value
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 1000) ' 1000 Hz rate is upper
' limit for the internal PC System Clock
' Select Group
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' a single channel
.Sel_chan_start = 0            ' start on channel 0
' allocate one buffer for the data
.Sel_buf_N = 10                 ' ten buffers used
.Sel_buf_samples = 1           ' one dummy sample in each buffer
' the buffer MUST be a multiple of how many channels are in the scan
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled message
End With

SR.Refresh  '  now carry out the task
If SR.Res_result <> DL_NoErr Then
' respond to error
lblStatus.Caption = SR.Message
Else
' no error occured
If optRisingEdge.Value = False Then
lblStatus.Caption = "Task Underway...Apply TTL clock signal to Pin 1."
Else
lblStatus.Caption = "Task Underway...Apply TTL clock signal to Pin 1"
End If
cmdStart.Enabled = False
cmdStop.Enabled = True
End If
End Sub

Private Sub cmdStop_Click()
With SR
.Req_op = DL_STOP
.Refresh
End With
cmdStop.Enabled = False
cmdStart.Enabled = True
Frame1.Enabled = True  ' allow edge selection again
End Sub

Private Sub Form_Load()
Dim i As Integer
For i = 0 To 5
devNum.AddItem Str(i), i  ' put legal values for device number into our combo box
Next i
devNum.ListIndex = 0 ' set it equal to first entry
End Sub

Private Sub optExternal_Click()
lblStatus.Caption = " Apply TTL clock signal to Pin 1"
End Sub

Private Sub optInternal_Click()
lblStatus.Caption = " PC System clock will be used for pacing"
End Sub

Private Sub SR_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
Static Counter As Single
Counter = Counter + 1
lblStatus.Caption = "IRQ detected " & Str(Counter) & " times"
' we don't really care about the data, we just want to know the edge at IRQ pin
' happened
End Sub


